﻿unit Finance_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const
Array_Items_FIN_IOS_APPLE_PAY: TSQL_Table_array = (
 (sql_col: 'DNT_TRANSACTION_DATE';            fex_col: 'Transaction Date';                  read_as: ftLargeInt;   convert_as: 'ABS';             col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_MERCHANT_NAME';               fex_col: 'Merchant';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CURRENCY_CODE';               fex_col: 'Currency';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_AMOUNT';                      fex_col: 'Amount';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TRANSACTION_TYPE';            fex_col: 'Transaction Type';                  read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TRANSACTION_STATUS';          fex_col: 'transaction_status';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LATITUDE';                    fex_col: 'Latitude';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LONGITUDE';                   fex_col: 'Longitude';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_FIN_IOS_APPLE_WALLET: TSQL_Table_array = (
 (sql_col: 'DNT_passTypeIdentifier';          fex_col: 'Pass Type';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_teamIdentifier';              fex_col: 'Company';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_description';                 fex_col: 'Description';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_creditcardnumber';            fex_col: 'Credit Card Number';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_expiryDate';                  fex_col: 'Expiration Date';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_issuerCountryCode';           fex_col: 'Issuer Country Code';               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_paymentType';                 fex_col: 'Payment Type';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_applicationDescription';      fex_col: 'Application Desc.';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_NULL: TSQL_Table_array = (
 (sql_col: '';
 fex_col: '';
 read_as: ftString;
 convert_as: '';
 col_type: ftString;
 show: false));

begin
   if Name = 'FIN_IOS_APPLE_PAY'                           then Result := Array_Items_FIN_IOS_APPLE_PAY else
   if Name = 'FIN_IOS_APPLE_WALLET'                        then Result := Array_Items_FIN_IOS_APPLE_WALLET else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Finance' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
